<?php
// http://localhost/jo_cos_system/seed_admin.php
declare(strict_types=1);
require_once __DIR__.'/includes/db.php';

$name = 'System Admin';
$email = 'admin@rms.local';
$plain = 'admin123'; // change after first login
$hash = password_hash($plain, PASSWORD_DEFAULT);

try {
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);

    if ($stmt->rowCount() > 0) {
        echo "Admin already exists: $email";
    } else {
        $stmt = $pdo->prepare("INSERT INTO users (name,email,password,role,status) VALUES (?,?,?,?,?)");
        $stmt->execute([$name, $email, $hash, 'admin', 'active']);
        echo "Admin created: $email / $plain";
    }
} catch (Throwable $e) {
    echo "Seeder error: " . $e->getMessage();
}
